/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epos;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class EPOSConfig {
    private String debugterminal;
    private Level debuglevel;
    private int timeout;
    private Set<String> initcodes;
    private Set<String> manualcodes;

    public void loadDebugTerminal(String value) {
        this.debugterminal = value;
    }

    public String getDebugTerminal() {
        return this.debugterminal;
    }

    public void loadDebugLevel(String value) {
        this.debuglevel = Level.parse(value == null || value.isEmpty() ? "WARNING" : value);
    }

    public Level getDebugLevel() {
        return this.debuglevel;
    }

    public void loadTimeout(String value) {
        this.timeout = Integer.parseInt(value == null || value.isEmpty() ? "0" : value);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void loadInitCodes(String value) {
        this.initcodes = this.loadSet(value);
    }

    public Set<String> getInitCodes() {
        return this.initcodes;
    }

    public void loadManualCodes(String value) {
        this.manualcodes = this.loadSet(value);
    }

    public Set<String> getManualCodes() {
        return this.manualcodes;
    }

    private Set<String> loadSet(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(value.split(",")).filter(s -> s != null && !s.isEmpty()).map(s -> s.trim()).collect(Collectors.toSet());
    }
}

