/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epos;

import com.openbravo.pos.epos.DevicePaymentPanel;
import com.openbravo.pos.epos.EPOSConfig;
import com.openbravo.pos.epos.PanEntryModeCodes;
import com.openbravo.pos.epos.ResponseCodes;
import com.openbravo.pos.epos.SocketManager;
import com.openbravo.pos.epos.XMLMessage;
import com.openbravo.pos.epos.XMLMessageBuilder;
import com.openbravo.pos.payment.DevicePayment;
import com.openbravo.pos.payment.PaymentRequest;
import com.openbravo.pos.payment.PaymentResult;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.Element;

public class EPOSDevicePayment
implements DevicePayment {
    private static final String MODULEVERSION = "1.0.530";
    private static final String EPOSVERSION2_3 = "2.3";
    private static final String EPOSVERSION2_8 = "2.8";
    private static final Logger logger = Logger.getLogger(EPOSDevicePayment.class.getName());
    private final DevicePaymentPanel panel;
    private final String server;
    private final int port;
    private final EPOSConfig config;
    private final String version;
    private final Set<String> initializedTerminals = new HashSet<String>();
    private final SocketManager socketmanager;

    public EPOSDevicePayment(String version, String url, EPOSConfig config) throws IOException {
        if (!url.startsWith("tcp://")) {
            throw new MalformedURLException(url);
        }
        int positionEnd = url.lastIndexOf(":");
        if (positionEnd < 0) {
            throw new MalformedURLException(url);
        }
        this.version = version.contains(EPOSVERSION2_8) ? EPOSVERSION2_8 : EPOSVERSION2_3;
        this.panel = new DevicePaymentPanel(this, config.getDebugTerminal());
        this.config = config;
        this.socketmanager = new SocketManager(config.getTimeout());
        this.server = url.substring(6, positionEnd);
        this.port = Integer.parseInt(url.substring(positionEnd + 1));
    }

    public String getName() {
        return "Postilion";
    }

    public String getDescription() {
        return "eSocket.POS. XML Message Interface version " + this.version + ". Module version " + MODULEVERSION + ".";
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public PaymentResult execute(PaymentRequest params) {
        try {
            String type;
            if (!this.isInitialized(params.getTerminalID())) {
                this.sendInit(params.getTerminalID());
            }
            switch (params.getType()) {
                case 0: {
                    type = "PURCHASE";
                    break;
                }
                case 1: {
                    type = "REFUND";
                    break;
                }
                default: {
                    return this.buildErrorResponse(params, "NotSupportedException", "Transaction type not supported.");
                }
            }
            XMLMessage request = XMLMessageBuilder.root("Esp:Interface").attr("Version", "1.0").attr("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").el("Esp:Transaction").attr("TerminalId", params.getTerminalID()).attr("TransactionAmount", Integer.toString(params.getAmount().multiply(BigDecimal.valueOf(100L)).intValue())).attr("TransactionId", params.getTransactionID()).attr("Type", type).attr("CurrencyCode", "ZWG".equalsIgnoreCase(params.getCurrency()) || "349".equalsIgnoreCase(params.getCurrency()) ? "924" : "840").build().buildXMLMessage();
            this.checkInitialized(params.getTerminalID());
            XMLMessage response = this.sendAndWaitResponse(params.getTerminalID(), request);
            Element e = (Element)response.getDocument().getFirstChild().getFirstChild();
            if ("Esp:Transaction".equals(e.getNodeName()) && "APPROVE".equals(e.getAttribute("ActionCode"))) {
                PaymentResult result = new PaymentResult();
                result.setResult(0);
                result.setResultCode(e.getAttribute("ResponseCode"));
                result.setResultMessage(e.getAttribute("MessageReasonCode"));
                result.setTransactionID(e.getAttribute("TransactionId"));
                result.setAuthorizationID(e.getAttribute("RetrievalRefNr"));
                result.setRequest(params);
                JSONObject properties = new JSONObject();
                properties.put("panentrymodecode", (Object)e.getAttribute("PanEntryMode"));
                properties.put("panentrymodemessage", (Object)PanEntryModeCodes.getMessage(e.getAttribute("PanEntryMode")));
                properties.put("cardmasked", (Object)e.getAttribute("CardNumber"));
                properties.put("cardlogo", (Object)e.getAttribute("CardProductName"));
                properties.put("cardexpiry", (Object)e.getAttribute("ExpiryDate"));
                properties.put("businessdate", (Object)e.getAttribute("BusinessDate"));
                properties.put("localdate", (Object)e.getAttribute("LocalDate"));
                properties.put("localtime", (Object)e.getAttribute("LocalTime"));
                result.setProperties(properties);
                logger.log(Level.INFO, "Approved payment *{0}* for terminal *{1}*.", new Object[]{params.getTransactionID(), params.getTerminalID()});
                return result;
            }
            return this.buildErrorResponse(params, e.getAttribute("ResponseCode"), ResponseCodes.getMessage(e.getAttribute("ResponseCode")));
        }
        catch (SocketException ex) {
            return this.buildErrorResponse(params, "SocketException", ex.getMessage());
        }
        catch (SocketTimeoutException ex) {
            return this.buildErrorResponse(params, "TimeoutException", ex.getMessage());
        }
        catch (IOException | JSONException ex) {
            return this.buildErrorResponse(params, "IOException", ex.getMessage());
        }
    }

    public PaymentResult buildErrorResponse(PaymentRequest request, String resultcode, String resultmessage) {
        if (this.config.getInitCodes().contains(resultcode)) {
            this.initializedTerminals.clear();
        }
        PaymentResult result = new PaymentResult();
        result.setResult(2);
        result.setResultCode(resultcode);
        result.setResultMessage(resultmessage);
        result.setTransactionID(request.getTransactionID());
        result.setAuthorizationID("");
        result.setRequest(request);
        JSONObject properties = new JSONObject();
        try {
            properties.put("allowManualPayment", this.config.getManualCodes().contains(resultcode));
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        result.setProperties(properties);
        logger.log(Level.WARNING, "Rejected payment *{0}* for terminal *{1}*.", new Object[]{request.getTransactionID(), request.getTerminalID()});
        return result;
    }

    public boolean isInitialized(String terminal) {
        return this.initializedTerminals.contains(terminal);
    }

    public void sendInit(String terminal) throws IOException {
        Element e;
        XMLMessage response;
        XMLMessage request;
        if (EPOSVERSION2_8.equals(this.version)) {
            request = XMLMessageBuilder.root("Esp:Interface").attr("Version", "1.0").attr("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").el("Esp:Admin").attr("TerminalId", terminal).attr("Action", "CLOSE").build().buildXMLMessage();
            response = this.sendAndWaitResponse(terminal, request);
            e = (Element)response.getDocument().getFirstChild().getFirstChild();
            if ("Esp:Error".equals(e.getNodeName())) {
                throw new IOException(e.getAttribute("Description"));
            }
            request = XMLMessageBuilder.root("Esp:Interface").attr("Version", "1.0").attr("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").el("Esp:Admin").attr("TerminalId", terminal).attr("Action", "INIT").el("Esp:Register").attr("EventId", "DATA_REQUIRED").attr("Type", "CALLBACK").build().el("Esp:Register").attr("EventId", "PROMPT_SWIPE_CARD").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "PROMPT_INSERT_CARD").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "UNSOLICITED_CARD_READ").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "CARD_INSERTED").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "REMOVE_CARD").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "PROMPT_TRANSACTION_PROCESSING").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "PROMPT_PAN").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "PIN_ENTRY").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "PROMPT_EMBOSSED_DIGITS").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "CANCEL_CARD_SWIPE").attr("Type", "EVENT").build().el("Esp:Register").attr("EventId", "CANCEL_TRAN").attr("Type", "EVENT").build().build().buildXMLMessage();
        } else {
            request = XMLMessageBuilder.root("Esp:Interface").attr("Version", "1.0").attr("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").el("Esp:Admin").attr("TerminalId", terminal).attr("Action", "INIT").el("Esp:Register").attr("EventId", "DATA_REQUIRED").attr("Type", "CALLBACK").build().el("Esp:Register").attr("EventId", "DEBUG_ALL").attr("Type", "EVENT").build().build().buildXMLMessage();
        }
        response = this.sendAndWaitResponse(terminal, request);
        e = (Element)response.getDocument().getFirstChild().getFirstChild();
        if ("Esp:Error".equals(e.getNodeName())) {
            throw new IOException(e.getAttribute("Description"));
        }
        this.initializedTerminals.add(terminal);
    }

    public void sendClose(String terminal) throws IOException {
        this.initializedTerminals.remove(terminal);
        XMLMessage request = XMLMessageBuilder.root("Esp:Interface").attr("Version", "1.0").attr("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").el("Esp:Admin").attr("TerminalId", terminal).attr("Action", "CLOSE").build().buildXMLMessage();
        this.checkInitialized(terminal);
        XMLMessage response = this.sendAndWaitResponse(terminal, request);
        Element e = (Element)response.getDocument().getFirstChild().getFirstChild();
        if ("Esp:Error".equals(e.getNodeName())) {
            throw new IOException(e.getAttribute("Description"));
        }
    }

    public XMLMessage sendAndWaitResponse(String terminal, XMLMessage request) throws IOException {
        this.uiLogger(Level.FINE, () -> "Sending:\n" + request.toFormattedString());
        XMLMessage response = this.socketmanager.sendAndWaitResponse(this.server, this.port, request, callback -> {
            Element e = (Element)callback.getDocument().getFirstChild().getFirstChild();
            if ("DATA_REQUIRED".equals(e.getAttribute("EventId"))) {
                try {
                    this.socketmanager.send(this.server, this.port, this.buildDataRequired(terminal, "0"));
                }
                catch (IOException ex) {
                    this.uiLogger(Level.SEVERE, ex, () -> ex.getMessage());
                    throw ex;
                }
            } else {
                IOException ex = new IOException("Callback not expected " + callback.toString());
                this.uiLogger(Level.SEVERE, ex, () -> ex.getMessage());
                throw ex;
            }
        });
        this.uiLogger(Level.FINE, () -> "Receiving:\n" + response.toFormattedString());
        return response;
    }

    private void checkInitialized(String terminal) throws IOException {
        if (!this.isInitialized(terminal)) {
            IOException ex = new IOException(String.format("Terminal %s is not initialized", terminal));
            this.uiLogger(Level.SEVERE, ex, () -> ex.getMessage());
            throw ex;
        }
    }

    private XMLMessage buildDataRequired(String terminal, String data) {
        XMLMessage callback = XMLMessageBuilder.root("Esp:Interface").attr("Version", "1.0").attr("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").el("Esp:Callback").attr("TerminalId", terminal).attr("EventId", "DATA_REQUIRED").attr("ResponseData", data).build().buildXMLMessage();
        return callback;
    }

    private void uiLogger(Level level, Supplier<String> str) {
        this.panelLogger(level, str);
        logger.log(level, str);
    }

    private void uiLogger(Level level, Throwable t, Supplier<String> str) {
        this.panelLogger(level, str);
        logger.log(level, t, str);
    }

    private void panelLogger(Level level, Supplier<String> str) {
        if (level.intValue() >= this.config.getDebugLevel().intValue()) {
            this.panel.printLogger(String.valueOf(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)) + ":" + level.toString() + ":" + str.get());
        }
    }
}

