/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epos;

import com.openbravo.pos.epos.SocketXMLMessage;
import com.openbravo.pos.epos.XMLMessage;
import com.openbravo.pos.epos.XMLMessageCallback;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class SocketManager {
    private static final int CONNECT_TIMEOUT = 5000;
    private final int readtimeout;
    private final Map<String, SocketXMLMessage> liveinstances = new HashMap<String, SocketXMLMessage>();

    public SocketManager(int readtimeout) {
        this.readtimeout = readtimeout;
    }

    private String getKey(String inputurl, int port) {
        return String.valueOf(inputurl) + ":" + Integer.toString(port);
    }

    private SocketXMLMessage getInstance(String inputurl, int port) {
        return this.liveinstances.get(this.getKey(inputurl, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String inputurl, int port, XMLMessage toSend) throws IOException {
        SocketXMLMessage client;
        Map<String, SocketXMLMessage> map = this.liveinstances;
        synchronized (map) {
            client = this.getInstance(inputurl, port);
            if (client == null) {
                throw new IOException("Socket instance on " + this.getKey(inputurl, port) + " does not exist.");
            }
        }
        client.send(toSend);
    }

    public XMLMessage sendAndWaitResponse(String inputurl, int port, XMLMessage toSend) throws IOException {
        return this.sendAndWaitResponse(inputurl, port, toSend, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMessage sendAndWaitResponse(String inputurl, int port, XMLMessage toSend, XMLMessageCallback callback) throws IOException {
        Map<String, SocketXMLMessage> map;
        XMLMessage xMLMessage;
        SocketXMLMessage client;
        Map<String, SocketXMLMessage> map2 = this.liveinstances;
        synchronized (map2) {
            if (this.getInstance(inputurl, port) != null) {
                throw new IOException("Socket instance on " + this.getKey(inputurl, port) + " already created.");
            }
            Socket socket = new Socket();
            socket.setSoTimeout(this.readtimeout);
            socket.connect(new InetSocketAddress(inputurl, port), 5000);
            client = new SocketXMLMessage(socket);
            this.liveinstances.put(this.getKey(inputurl, port), client);
        }
        try {
            XMLMessage result;
            xMLMessage = result = client.sendAndWaitResponse(toSend, callback);
            map = this.liveinstances;
        }
        catch (Throwable throwable) {
            Map<String, SocketXMLMessage> map3 = this.liveinstances;
            synchronized (map3) {
                this.liveinstances.remove(this.getKey(inputurl, port));
                client.close();
            }
            throw throwable;
        }
        synchronized (map) {
            this.liveinstances.remove(this.getKey(inputurl, port));
            client.close();
        }
        return xMLMessage;
    }
}

