/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epos;

import com.openbravo.pos.epos.XMLMessage;
import com.openbravo.pos.epos.XMLMessageCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketXMLMessage {
    private static final Logger logger = Logger.getLogger(SocketXMLMessage.class.getName());
    private final Socket socket;
    private final OutputStream out;
    private final InputStream in;

    public SocketXMLMessage(Socket socket) throws IOException {
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
    }

    public XMLMessage readResponse() throws IOException {
        XMLMessage response = XMLMessage.read(this.in);
        logger.fine(() -> "Receiving from " + this.socket.toString() + " : " + response.toString());
        return response;
    }

    public void send(XMLMessage toSend) throws IOException {
        logger.fine(() -> "Sending to " + this.socket.toString() + " : " + toSend.toString());
        this.out.write(toSend.toBytes());
        this.out.flush();
    }

    public XMLMessage sendAndWaitResponse(XMLMessage toSend, XMLMessageCallback callback) throws IOException {
        XMLMessage response;
        this.send(toSend);
        while (!(response = this.readResponse()).isResponse()) {
            XMLMessage responselogged = response;
            logger.log(Level.FINE, () -> responselogged.toString());
            if (!response.isCallback()) continue;
            if (callback == null) {
                String message = "Unexpected response: " + responselogged.toString();
                logger.log(Level.WARNING, message);
                throw new IOException(message);
            }
            callback.apply(response);
        }
        return response;
    }
}

