/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.eposerver;

import com.openbravo.pos.eposerver.SocketHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicBoolean;

public class MockServer {
    private static final int PORT = 23001;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ServerSocket listener;

    public synchronized void startServer() throws IOException {
        if (this.running.get()) {
            throw new IOException("Server already started.");
        }
        this.listener = new ServerSocket(23001);
        Thread t = new Thread(() -> {
            block5: {
                this.running.set(true);
                try {
                    while (this.running.get()) {
                        new SocketHandler(this.listener.accept()).start();
                    }
                }
                catch (IOException ex) {
                    if (!this.running.get()) break block5;
                    try {
                        this.stopServer();
                        throw ex;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        t.start();
    }

    public synchronized void stopServer() throws IOException {
        if (!this.running.get()) {
            throw new IOException("Server already stopped.");
        }
        this.running.set(false);
        this.listener.close();
        this.listener = null;
    }

    public boolean isRunning() {
        return this.running.get();
    }
}

