/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.eposerver;

import com.openbravo.pos.epos.SocketXMLMessage;
import com.openbravo.pos.epos.XMLMessage;
import com.openbravo.pos.epos.XMLMessageBuilder;
import java.io.IOException;
import java.net.Socket;
import org.w3c.dom.Element;

public class SocketHandler
extends Thread {
    private final SocketXMLMessage socketmessage;

    public SocketHandler(Socket socket) throws IOException {
        this.socketmessage = new SocketXMLMessage(socket);
    }

    @Override
    public void run() {
        try {
            XMLMessage request;
            XMLMessage message = this.socketmessage.readResponse();
            System.out.println(message.toString());
            Element e = (Element)message.getDocument().getFirstChild().getFirstChild();
            if ("Esp:Admin".equals(e.getNodeName())) {
                String action = e.getAttribute("Action");
                request = XMLMessageBuilder.root("Esp:Interface").attr("Version", "1.0").attr("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").el("Esp:Admin").attr("Action", action).attr("ActionCode", "APPROVE").attr("MessageReasonCode", "9791").attr("TerminalId", "faketerminal").build().buildXMLMessage();
            } else if ("Esp:Transaction".equals(e.getNodeName())) {
                String amount = e.getAttribute("TransactionAmount");
                if ("10001".equals(amount)) {
                    this.sleepFor(500);
                    request = this.getErrorResponse(e, "91");
                } else if ("10002".equals(amount)) {
                    this.sleepFor(500);
                    request = this.getErrorResponse(e, "30");
                } else if ("10003".equals(amount)) {
                    this.sleepFor(20000);
                    request = this.getValidTransactionResponse(e);
                } else {
                    this.sleepFor(1000);
                    request = this.getValidTransactionResponse(e);
                }
            } else {
                request = this.getErrorResponse(e, "06");
            }
            this.socketmessage.send(request);
            this.socketmessage.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sleepFor(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private XMLMessage getValidTransactionResponse(Element e) {
        String type = e.getAttribute("Type");
        String amount = e.getAttribute("TransactionAmount");
        String terminal = e.getAttribute("TerminalId");
        String transactionid = e.getAttribute("TransactionId");
        return XMLMessageBuilder.root("Esp:Interface").attr("Version", "1.0").attr("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").el("Esp:Transaction").attr("ActionCode", "APPROVE").attr("ResponseCode", "00").attr("MessageReasonCode", "0000").attr("TerminalId", terminal).attr("Account", "10").attr("CardNumber", "1111222233334444").attr("CardProductName", "MOCK").attr("LocalDate", "2018-09-09").attr("LocalTime", "2018-09-09").attr("CurrencyCode", "840").attr("DateTime", "0721084817").attr("ExpiryDate", "0929").attr("MerchantId", "1234556").attr("PanEntryMode", "00").attr("PosCondition", "00").attr("TransactionAmount", amount).attr("TransactionId", transactionid).attr("Type", type).build().buildXMLMessage();
    }

    private XMLMessage getErrorResponse(Element e, String responsecode) {
        return XMLMessageBuilder.root("Esp:Interface").attr("Version", "1.0").attr("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").el("Esp:Error").attr("ResponseCode", responsecode).attr("MessageReasonCode", "9791").attr("TerminalId", "faketerminal").build().buildXMLMessage();
    }
}

