/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epos;

import com.openbravo.pos.epos.EPOSDevicePayment;
import com.openbravo.pos.epos.XMLMessage;
import com.openbravo.pos.epos.XMLMessageBuilder;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class DevicePaymentPanel
extends JPanel {
    private final EPOSDevicePayment dp;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField txtTerminal;

    public DevicePaymentPanel(EPOSDevicePayment dp, String debugterminal) {
        this.dp = dp;
        this.initComponents();
        this.txtTerminal.setText(debugterminal);
    }

    public void printLogger(String str) {
        SwingUtilities.invokeLater(() -> this.jTextArea1.insert(str + "\n", this.jTextArea1.getDocument().getLength()));
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jLabel1 = new JLabel();
        this.txtTerminal = new JTextField();
        this.jButton1.setText("Init");
        this.jButton1.setToolTipText("");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePaymentPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jButton2.setText("Close");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePaymentPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Purchase");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePaymentPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Terminal ID");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 567, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtTerminal))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jButton3).addComponent(this.jLabel1).addComponent(this.txtTerminal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 251, Short.MAX_VALUE).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        ForkJoinPool.commonPool().execute(() -> {
            try {
                this.dp.sendInit(this.txtTerminal.getText());
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, "Terminal initialized", "eSocket.POS Message", 1));
            }
            catch (IOException ex) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, ex.getMessage(), "eSocket.POS Error", 0));
            }
        });
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        ForkJoinPool.commonPool().execute(() -> {
            try {
                this.dp.sendClose(this.txtTerminal.getText());
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, "Terminal closed", "eSocket.POS Message", 1));
            }
            catch (IOException ex) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, ex.getMessage(), "eSocket.POS Error", 0));
            }
        });
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        ForkJoinPool.commonPool().execute(() -> {
            XMLMessage request = XMLMessageBuilder.root("Esp:Interface").attribute("Version", "1.0").attribute("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").element("Esp:Transaction").attribute("TerminalId", this.txtTerminal.getText()).attribute("TransactionId", (Integer.toString(new Random().nextInt(100000)) + "0000000").substring(0, 6)).attribute("TransactionAmount", "120").attribute("Type", "PURCHASE").build().buildXMLMessage();
            try {
                XMLMessage response = this.dp.sendAndWaitResponse(this.txtTerminal.getText(), request);
                Element e = (Element)response.getDocument().getFirstChild().getFirstChild();
                if ("Esp:Transaction".equals(e.getNodeName()) && "APPROVE".equals(e.getAttribute("ActionCode"))) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, "Transaction approved", "eSocket.POS Message", 1));
                } else {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, "Transaction rejected", "eSocket.POS Message", 2));
                }
            }
            catch (IOException ex) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, ex.getMessage(), "eSocket.POS Error", 0));
            }
        });
    }
}

