/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epos;

import com.openbravo.pos.epos.DevicePaymentPanel;
import com.openbravo.pos.epos.PanEntryModeCodes;
import com.openbravo.pos.epos.ResponseCodes;
import com.openbravo.pos.epos.SocketManager;
import com.openbravo.pos.epos.XMLMessage;
import com.openbravo.pos.epos.XMLMessageBuilder;
import com.openbravo.pos.payment.DevicePayment;
import com.openbravo.pos.payment.PaymentRequest;
import com.openbravo.pos.payment.PaymentResult;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.Element;

public class EPOSDevicePayment
implements DevicePayment {
    private static final Logger logger = Logger.getLogger(EPOSDevicePayment.class.getName());
    private final DevicePaymentPanel panel;
    private final String server;
    private final int port;
    private final Level debuglevel;
    private final Set<String> initializedTerminals = new HashSet<String>();

    public EPOSDevicePayment(String url, String debugterminal, Level debuglevel) throws IOException {
        if (!url.startsWith("tcp://")) {
            throw new MalformedURLException(url);
        }
        int positionEnd = url.lastIndexOf(":");
        if (positionEnd < 0) {
            throw new MalformedURLException(url);
        }
        this.panel = new DevicePaymentPanel(this, debugterminal);
        this.debuglevel = debuglevel;
        this.server = url.substring(6, positionEnd);
        this.port = Integer.parseInt(url.substring(positionEnd + 1));
    }

    public String getName() {
        return "Postilion";
    }

    public String getDescription() {
        return "eSocket.POS XML Message Interface.";
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public PaymentResult execute(PaymentRequest params) {
        try {
            String type;
            if (!this.isInitialized(params.getTerminalID())) {
                this.sendInit(params.getTerminalID());
            }
            switch (params.getType()) {
                case 0: {
                    type = "PURCHASE";
                    break;
                }
                case 1: {
                    type = "REFUND";
                    break;
                }
                default: {
                    return this.buildErrorResponse(params, "Transaction type not supported.");
                }
            }
            String currency = params.getCurrency();
            if (currency == null || currency.isEmpty()) {
                return this.buildErrorResponse(params, "No currency specified.");
            }
            String numericCurrCode = this.getNumericCurrencyCode(currency);
            if (numericCurrCode == null) {
                return this.buildErrorResponse(params, "Currency not supported: " + currency);
            }
            XMLMessage request = XMLMessageBuilder.root("Esp:Interface").attribute("Version", "1.0").attribute("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").element("Esp:Transaction").attribute("TerminalId", params.getTerminalID()).attribute("TransactionId", params.getTransactionID()).attribute("TransactionAmount", Integer.toString(params.getAmount().multiply(BigDecimal.valueOf(100L)).intValue())).attribute("CurrencyCode", numericCurrCode).attribute("Type", type).build().buildXMLMessage();
            XMLMessage response = this.sendAndWaitResponse(params.getTerminalID(), request);
            Element e = (Element)response.getDocument().getFirstChild().getFirstChild();
            if ("Esp:Transaction".equals(e.getNodeName()) && "APPROVE".equals(e.getAttribute("ActionCode"))) {
                PaymentResult paymentResult = new PaymentResult();
                paymentResult.setResult(0);
                paymentResult.setResultCode(e.getAttribute("ResponseCode"));
                paymentResult.setResultMessage(e.getAttribute("MessageReasonCode"));
                paymentResult.setTransactionID(e.getAttribute("TransactionId"));
                paymentResult.setAuthorizationID(e.getAttribute("RetrievalRefNr"));
                paymentResult.setRequest(params);
                JSONObject properties = new JSONObject();
                properties.put("panentrymodecode", (Object)e.getAttribute("PanEntryMode"));
                properties.put("panentrymodemessage", (Object)PanEntryModeCodes.getMessage(e.getAttribute("PanEntryMode")));
                properties.put("cardmasked", (Object)e.getAttribute("CardNumber"));
                properties.put("cardlogo", (Object)e.getAttribute("CardProductName"));
                properties.put("cardexpiry", (Object)e.getAttribute("ExpiryDate"));
                properties.put("businessdate", (Object)e.getAttribute("BusinessDate"));
                properties.put("localdate", (Object)e.getAttribute("LocalDate"));
                properties.put("localtime", (Object)e.getAttribute("LocalTime"));
                paymentResult.setProperties(properties);
                return paymentResult;
            }
            PaymentResult result = new PaymentResult();
            result.setResult(2);
            result.setResultCode(e.getAttribute("ResponseCode"));
            result.setResultMessage(ResponseCodes.getMessage(e.getAttribute("ResponseCode")));
            result.setTransactionID(params.getTransactionID());
            result.setAuthorizationID("");
            result.setRequest(params);
            return result;
        }
        catch (IOException | JSONException ex) {
            return this.buildErrorResponse(params, ex.getMessage());
        }
    }

    private String getNumericCurrencyCode(String currency) {
        String numericCurrCode = null;
        switch (currency) {
            case "USD": {
                numericCurrCode = "840";
                break;
            }
            case "ZAR": {
                numericCurrCode = "710";
                break;
            }
            case "ZWG": {
                numericCurrCode = "924";
            }
        }
        return numericCurrCode;
    }

    public PaymentResult buildErrorResponse(PaymentRequest request, String resultmessage) {
        PaymentResult result = new PaymentResult();
        result.setResult(2);
        result.setResultCode("");
        result.setResultMessage(resultmessage);
        result.setTransactionID(request.getTransactionID());
        result.setAuthorizationID("");
        result.setRequest(request);
        return result;
    }

    public boolean isInitialized(String terminal) {
        return this.initializedTerminals.contains(terminal);
    }

    public void sendInit(String terminal) throws IOException {
        XMLMessage request = XMLMessageBuilder.root("Esp:Interface").attribute("Version", "1.0").attribute("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").element("Esp:Admin").attribute("TerminalId", terminal).attribute("Action", "INIT").element("Esp:Register").attribute("Type", "CALLBACK").attribute("EventId", "DATA_REQUIRED").build().element("Esp:Register").attribute("Type", "EVENT").attribute("EventId", "DEBUG_ALL").build().build().buildXMLMessage();
        this.initializedTerminals.add(terminal);
        XMLMessage response = this.sendAndWaitResponse(terminal, request);
        Element e = (Element)response.getDocument().getFirstChild().getFirstChild();
        if ("Esp:Error".equals(e.getNodeName())) {
            this.initializedTerminals.remove(terminal);
            throw new IOException(e.getAttribute("Description"));
        }
    }

    public void sendClose(String terminal) throws IOException {
        XMLMessage request = XMLMessageBuilder.root("Esp:Interface").attribute("Version", "1.0").attribute("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").element("Esp:Admin").attribute("TerminalId", terminal).attribute("Action", "CLOSE").build().buildXMLMessage();
        XMLMessage response = this.sendAndWaitResponse(terminal, request);
        this.initializedTerminals.remove(terminal);
        Element e = (Element)response.getDocument().getFirstChild().getFirstChild();
        if ("Esp:Error".equals(e.getNodeName())) {
            throw new IOException(e.getAttribute("Description"));
        }
    }

    public XMLMessage sendAndWaitResponse(String terminal, XMLMessage request) throws IOException {
        if (!this.isInitialized(terminal)) {
            IOException ex = new IOException(String.format("Terminal %s is not initialized", terminal));
            this.uiLogger(Level.SEVERE, ex, () -> ex.getMessage());
            throw ex;
        }
        this.uiLogger(Level.FINE, () -> "Sending:\n" + request.toString());
        XMLMessage response = SocketManager.sendAndWaitResponse(this.server, this.port, request, callback -> {
            Element e = (Element)callback.getDocument().getFirstChild().getFirstChild();
            if ("DATA_REQUIRED".equals(e.getAttribute("EventId"))) {
                try {
                    SocketManager.send(this.server, this.port, this.buildDataRequired(terminal, "0"));
                }
                catch (IOException ex) {
                    this.initializedTerminals.clear();
                    this.uiLogger(Level.SEVERE, ex, () -> ex.getMessage());
                    throw ex;
                }
            } else {
                IOException ex = new IOException("Callback not expected " + callback.toString());
                this.uiLogger(Level.SEVERE, ex, () -> ex.getMessage());
                throw ex;
            }
        });
        this.uiLogger(Level.FINE, () -> "Receiving:\n" + response.toString());
        return response;
    }

    private XMLMessage buildDataRequired(String terminal, String data) {
        XMLMessage callback = XMLMessageBuilder.root("Esp:Interface").attribute("Version", "1.0").attribute("xmlns:Esp", "http://www.mosaicsoftware.com/Postilion/eSocket.POS/").element("Esp:Callback").attribute("TerminalId", terminal).attribute("EventId", "DATA_REQUIRED").attribute("ResponseData", data).build().buildXMLMessage();
        return callback;
    }

    private void uiLogger(Level level, Supplier<String> str) {
        this.panelLogger(level, str);
        logger.log(level, str);
    }

    private void uiLogger(Level level, Throwable t, Supplier<String> str) {
        this.panelLogger(level, str);
        logger.log(level, t, str);
    }

    private void panelLogger(Level level, Supplier<String> str) {
        if (level.intValue() >= this.debuglevel.intValue()) {
            this.panel.printLogger(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + ":" + level.toString() + ":" + str.get());
        }
    }
}

