/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epos;

import com.openbravo.pos.epos.XMLMessage;
import com.openbravo.pos.epos.XMLMessageCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketManager {
    private static final Logger logger = Logger.getLogger(SocketManager.class.getName());
    private static final Map<String, SocketManager> liveinstances = new HashMap<String, SocketManager>();
    private final Socket socket;
    private final OutputStream out;
    private final InputStream in;

    private SocketManager(String inputurl, int port) throws IOException {
        this.socket = new Socket(inputurl, port);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
    }

    private void close() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
    }

    private XMLMessage readResponse() throws IOException {
        XMLMessage response = XMLMessage.read(this.in);
        logger.fine(() -> "Receiving from " + this.socket.toString() + " : " + response.toString());
        return response;
    }

    private void send(XMLMessage toSend) throws IOException {
        logger.fine(() -> "Sending to " + this.socket.toString() + " : " + toSend.toString());
        this.out.write(toSend.toBytes());
        this.out.flush();
    }

    private XMLMessage sendAndWaitResponse(XMLMessage toSend, XMLMessageCallback callback) throws IOException {
        XMLMessage response;
        this.send(toSend);
        while (!(response = this.readResponse()).isResponse()) {
            XMLMessage responselogged = response;
            logger.log(Level.FINE, () -> responselogged.toString());
            if (!response.isCallback()) continue;
            if (callback == null) {
                String message = "Unexpected response " + responselogged.toString();
                logger.log(Level.WARNING, message);
                throw new IOException(message);
            }
            callback.apply(response);
        }
        return response;
    }

    private static String getKey(String inputurl, int port) {
        return inputurl + ":" + Integer.toString(port);
    }

    private static SocketManager getInstance(String inputurl, int port) {
        return liveinstances.get(SocketManager.getKey(inputurl, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(String inputurl, int port, XMLMessage toSend) throws IOException {
        SocketManager client;
        Map<String, SocketManager> map = liveinstances;
        synchronized (map) {
            client = SocketManager.getInstance(inputurl, port);
            if (client == null) {
                throw new IOException("Socket instance on " + SocketManager.getKey(inputurl, port) + " does not exist.");
            }
        }
        client.send(toSend);
    }

    public static XMLMessage sendAndWaitResponse(String inputurl, int port, XMLMessage toSend) throws IOException {
        return SocketManager.sendAndWaitResponse(inputurl, port, toSend, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLMessage sendAndWaitResponse(String inputurl, int port, XMLMessage toSend, XMLMessageCallback callback) throws IOException {
        SocketManager client;
        Map<String, SocketManager> map = liveinstances;
        synchronized (map) {
            if (SocketManager.getInstance(inputurl, port) != null) {
                throw new IOException("Socket instance on " + SocketManager.getKey(inputurl, port) + " already created.");
            }
            client = new SocketManager(inputurl, port);
            liveinstances.put(SocketManager.getKey(inputurl, port), client);
        }
        XMLMessage result = client.sendAndWaitResponse(toSend, callback);
        Map<String, SocketManager> map2 = liveinstances;
        synchronized (map2) {
            client.close();
            liveinstances.remove(SocketManager.getKey(inputurl, port));
        }
        return result;
    }
}

