/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLMessage {
    private static final Logger logger = Logger.getLogger(XMLMessage.class.getName());
    private final Document doc;

    public XMLMessage(Document doc) {
        this.doc = doc;
    }

    public static final XMLMessage fromString(String msgStr) throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return new XMLMessage(builder.parse(new ByteArrayInputStream(msgStr.getBytes(StandardCharsets.UTF_8))));
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IOException(ex);
        }
    }

    public static final XMLMessage read(InputStream in) throws IOException {
        int msgLength = 0;
        int bytesRead = 0;
        byte[] msgBuffer = new byte[]{};
        try {
            byte[] buffer = new byte[2];
            in.read(buffer);
            if (buffer[0] == -1 && buffer[1] == -1) {
                buffer = new byte[4];
                in.read(buffer);
                msgLength = (buffer[0] & 0xFF) << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
            } else {
                msgLength = (buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF;
            }
            msgBuffer = new byte[msgLength];
            bytesRead = in.read(msgBuffer);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return new XMLMessage(builder.parse(new ByteArrayInputStream(msgBuffer)));
        }
        catch (ParserConfigurationException | SAXException ex) {
            XMLMessage xmlMessage;
            if (ex instanceof SAXParseException && bytesRead > 0 && bytesRead < msgLength && (xmlMessage = XMLMessage.attemptToReadRemainingBytes(in, msgBuffer, msgLength, bytesRead)) != null) {
                return xmlMessage;
            }
            throw new IOException(ex);
        }
    }

    private static XMLMessage attemptToReadRemainingBytes(InputStream in, byte[] msgBuffer, int msgLength, int bytesRead) throws IOException {
        try {
            int remainingBytesRead;
            int nrRemainingBytes = msgLength - bytesRead;
            byte[] remainingMsgBytes = new byte[nrRemainingBytes];
            for (int offset = bytesRead; offset < msgLength; offset += remainingBytesRead) {
                remainingBytesRead = in.read(remainingMsgBytes);
                System.arraycopy(remainingMsgBytes, 0, msgBuffer, offset, remainingBytesRead);
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            XMLMessage xmlMessage = new XMLMessage(builder.parse(new ByteArrayInputStream(msgBuffer)));
            if (xmlMessage.isValidXmlMessage()) {
                return xmlMessage;
            }
            return null;
        }
        catch (ParserConfigurationException | SAXException ex) {
            logger.log(Level.SEVERE, "Exception parsing XML message: " + ex.getMessage(), ex);
            throw new IOException(ex);
        }
    }

    private boolean isValidXmlMessage() {
        Element element = (Element)this.getDocument().getFirstChild().getFirstChild();
        if (!"Esp:Transaction".equals(element.getNodeName())) {
            return true;
        }
        String actionCode = element.getAttribute("ActionCode");
        String reversalFlag = element.getAttribute("Reversal");
        if (!"APPROVE".equals(actionCode)) {
            return true;
        }
        if ("TRUE".equalsIgnoreCase(reversalFlag)) {
            return true;
        }
        String msgReasonCode = element.getAttribute("MessageReasonCode");
        if ("9620".equals(msgReasonCode)) {
            return true;
        }
        NodeList nodeList = element.getChildNodes();
        boolean validResponse = false;
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String name;
            Element nodeElement = (Element)nodeList.item(i);
            if (!"Esp:StructuredData".equals(nodeElement.getNodeName()) || !"Acquirer".equals(name = nodeElement.getAttribute("Name"))) continue;
            validResponse = true;
            break;
        }
        return validResponse;
    }

    public String toString() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(this.doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException ex) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n <Esp:Interface Version=\"1.0\" xmlns:Esp=\"http://www.mosaicsoftware.com/Postilion/eSocket.POS/\">Error</Esp:Interface>";
        }
    }

    public byte[] toBytes() {
        byte[] buffer = this.toString().getBytes(StandardCharsets.UTF_8);
        int length = buffer.length;
        byte[] header = length < 65535 ? new byte[]{(byte)(length >> 8), (byte)length} : new byte[]{-1, -1, (byte)(length >> 24), (byte)(length >> 16), (byte)length, (byte)length};
        return this.concat(header, buffer);
    }

    public Document getDocument() {
        return this.doc;
    }

    private byte[] concat(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] c = new byte[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public boolean isCallback() {
        Node n = this.doc.getFirstChild().getFirstChild();
        return "Esp:Callback".equals(n.getNodeName());
    }

    public boolean isResponse() {
        Node n = this.doc.getFirstChild().getFirstChild();
        return !"Esp:Event".equals(n.getNodeName()) && !this.isCallback();
    }
}

