/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epos;

import com.openbravo.pos.epos.XMLMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLMessageBuilder {
    private final XMLMessageBuilder parent;
    private final Document doc;
    private final Element el;

    public static XMLMessageBuilder root(String roottag) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(roottag);
            doc.appendChild(root);
            return new XMLMessageBuilder(null, doc, root);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLMessageBuilder(XMLMessageBuilder parent, Document doc, Element el) {
        this.parent = parent;
        this.doc = doc;
        this.el = el;
    }

    public XMLMessageBuilder attribute(String name, String value) {
        this.el.setAttribute(name, value);
        return this;
    }

    public XMLMessageBuilder element(String tag) {
        Element childel = this.doc.createElement(tag);
        this.el.appendChild(childel);
        return new XMLMessageBuilder(this, this.doc, childel);
    }

    public XMLMessageBuilder build() {
        return this.parent;
    }

    public XMLMessage buildXMLMessage() {
        return new XMLMessage(this.doc);
    }
}

